﻿
namespace Framework
{
    /// <summary>
    /// object の拡張メソッドです。
    /// </summary>
    public static class ObjectExtension
    {
        /// <summary>
        /// null安全なToStringメソッドです。
        /// nullでこのメソッドを呼び出した場合、文字列nullが返ります。
        /// </summary>
        public static string ToStr(this object target)
        {
            return target == null ? "null" : target.ToString();
        }

        /// <summary>
        /// 2つのオブジェクトをEqualsメソッドにより比較します。
        /// nullで起動し、objもnullの場合、trueを返します。
        /// </summary>
        public static bool Eq(this object target, object obj)
        {
            if ((target ?? obj) == null)
                return true;
            if (target == null)
                return false;
            return target.Equals(obj);
        }
    }
}
